<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Autopilot\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class RestoreAssistantList extends ListResource {
    /**
     * Construct the RestoreAssistantList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(Version $version) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [];

        $this->uri = '/Assistants/Restore';
    }

    /**
     * Update the RestoreAssistantInstance
     *
     * @param string $assistant The unique string that identifies the resource
     * @return RestoreAssistantInstance Updated RestoreAssistantInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function update(string $assistant): RestoreAssistantInstance {
        $data = Values::of(['Assistant' => $assistant, ]);

        $payload = $this->version->update('POST', $this->uri, [], $data);

        return new RestoreAssistantInstance($this->version, $payload);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Autopilot.V1.RestoreAssistantList]';
    }
}